vec3 DrawShootingStar(vec3 clr, vec3 viewPos, float variation, float dither) {

	float frameShootingStar = frameTimeCounter / SPEED_SHOOTING;
	float visibility = 1.0;

	#ifdef OVERWORLD
	visibility = moonVisibility;
	#endif

	float sectime = mod(frameShootingStar, 1.0);

	float lim1 = 49.0 * variation;
	float lim2 = 69.0 * variation;

	float time1 = mod(floor(frameShootingStar), lim1) / lim1;
	float time2 = mod(floor(frameShootingStar), lim2) / lim2;

	vec3 wpos = vec3(gbufferModelViewInverse * vec4(viewPos, 1.0));
	vec3 sstarpos1start = texture2D(noisetex, vec2(time1, time2)).rgb;
	sstarpos1start.xz = (sstarpos1start.xz * 2.0) - 1.0;
	sstarpos1start.y = (sstarpos1start.y * 0.9) + 0.1;
	vec3 sstarpos2start = texture2D(noisetex, vec2(1.0 - time1, 1.0 - time2)).rgb;
	sstarpos2start.xz = (sstarpos2start.xz * 2.0) - 1.0;
	sstarpos2start.y = (sstarpos2start.y * 0.9) + 0.1;

	float isShooting = texture2D(noisetex, vec2(time2, time1)).r;

	sstarpos1start = normalize(sstarpos1start);
	sstarpos2start = normalize(sstarpos2start);
	if (length(sstarpos1start - sstarpos2start) > 0.7 && visibility > 0.0 && isShooting < SHOW_DELAY) {
		vec3 sstarpos1;
		vec3 sstarpos2;
		if (sectime < 0.5) {
			sstarpos1 = mix(sstarpos2start, sstarpos1start, sectime * 2.0);
			sstarpos2 = sstarpos2start;
		} else {
			sstarpos1 = sstarpos1start;
			sstarpos2 = mix(sstarpos1start, sstarpos2start, (1.0 - sectime) * 2.0);

		}
		sstarpos1 = normalize(sstarpos1);
		sstarpos2 = normalize(sstarpos2);
		wpos = normalize(wpos);

		float starsTickness = STAR_THICKNESS * 0.01;

		float l1 = length(sstarpos1 - wpos);
		float l2 = length(sstarpos2 - wpos);
		float l3 = length(sstarpos1 - sstarpos2);
		if (l3 < starsTickness)
		l3 = starsTickness;
		float l4 = length(((sstarpos1 + sstarpos2) / 2.0) - wpos);

		vec3 ss3 = cross(sstarpos1, sstarpos2);
		ss3 = normalize(ss3);
		float dist = dot(wpos, ss3);

		if (dist < 0)
		dist = - dist;
		if ((dist < starsTickness && l3 > l1 && l3 > l2)|| l1 < starsTickness) {

			float t1 = 1.0 - (dist / starsTickness);
			float t2 = 1.0 - (l1 / l3);
			t2 = pow(t2, SHOOTING_STARS_FADE);
			float t = t1 * t2 * dither;
			float fade = clamp01((1.0 - sectime));
			fade = clamp01(pow(fade, 30.0) * 700.0);

			clr = mix(clr, vec3(SHOOTING_INTENSITY) * 30.0 * pow2((1.0 - rainFactor)), t * fade);

		}
	}

	return clr;
}